var inquiryButton = document.getElementById("inquiry");

var qrScanButton = document.getElementById("qrScan");

var serialNumber = document.getElementById("serialNumber");

var warrantyStatus = document.getElementById("status");

var warrantyDevName = document.getElementById("devName");

var warrantyDevSerialNumber = document.getElementById("devSerialNumber");

var warrantyDeviceType = document.getElementById("devDeviceType");

var warrantyValidUntil = document.getElementById("validUntil");

var warrantySection = document.getElementById("warrantySection");

var loading = document.getElementById("loading");

var submitText = document.getElementById("submitText");

var agentCode = "iRaNfIbEr.Ir";

var baseUrl = "https://vps.behamad.ir:2096/api";



const p2e = s => s.replace(/[۰-۹]/g, d => '۰۱۲۳۴۵۶۷۸۹'.indexOf(d));


function convertDate(timestamp){

    var days = ["دوشنبه", "سه شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه", "یکشنبه"];

    var monthes = [

        "فروردین",

        "اردیبهشت",

        "خرداد",

        "تیر",

        "مرداد",

        "شهریور",

        "مهر",

        "آبان",

        "آذر",

        "دی",

        "بهمن",

        "اسفند"

    ];

    var date = new Date(timestamp);

    var jalaliDate = date.toLocaleDateString("fa-ir")

    var dateField = jalaliDate.split("/");

    var year = parseInt(p2e(dateField[0]));

    var month = parseInt(p2e(dateField[1]));

    var day = parseInt(p2e(dateField[2]));

    var dayOfWeek = days[date.getDay() - 1];

    var monthInWord = monthes[month - 1];

    var result = {

        "YEAR": year,

        "MONTH": month,

        "DAY": day,

        "DAY_OF_WEEK": dayOfWeek,

        "FULL": dayOfWeek + " " + dateField[2] + " " + monthInWord + " " + dateField[0]
        
    }

    return result.FULL;

}

async function inquryWarranty(serialNumber){

    var messages = {

        "INVALID_AGENT_CODE": "Invalid Agent Code",

        "INVALID_SERIAL_NUMBER": "Invalid Serial Number",

        "NO_DEVICE": "No Device with specific serial number",

        "NO_WARRANTY": "No Warranty Associate to this device"

    }


    var deviceTypes = {

        "MODEM": "modem"

    }

    var endPoint = "/iranfiber/inquiryWarranty";

    var request = fetch(baseUrl+endPoint,{

        method: "POST",

        headers:{

            "Content-Type": "application/json"

        },

        body:JSON.stringify({

            "serialNumber": serialNumber,

            "agentCode": agentCode

        })

    });

    request.then((response)=>{

        var status = false;

        var devName = "";

        var devSerialNumber= "";

        var devDeviceType = "";

        var validUntil = "";

        var message = "";

        var result = {}

        response.json().then((jsonResponse)=>{

            submitText.style.display = "inline-block";

            loading.style.display = "none";

            if(!jsonResponse.status){

                switch (jsonResponse.message) {

                    case messages.INVALID_AGENT_CODE:

                        message = "درخواست نامعتبر. با پشتیبانی تماس بگیرید";
                        
                        break;

                    case messages.INVALID_SERIAL_NUMBER:

                        message = "سریال نامبر وارد شده نامعتبر است";

                        break;

                    case messages.NO_DEVICE:

                        message = "دستگاه با سریال نامبر وارد شده وجود ندارد";

                        break;

                    case messages.NO_WARRANTY:

                        message = "ضمانت/اصلالت کالا برای دستگاه دریافتی وجود ندارد. با پشتیبانی تماس بگیرید"

                        break;
                
                    default:

                        message = "خطای سیستمی. لطفا بعدا تلاش فرمایید";

                        break;
                }

                alert(message);

            }

            else{

                warrantySection.style.display = "inline";

                var data = jsonResponse.data;

                status = data.status;

                devName = data.device.name;

                devSerialNumber = data.device.serialNumber;

                validUntil = convertDate(data.validUntil);

                switch (data.device.deviceType) {
                    case deviceTypes.MODEM:
                        
                        devDeviceType = "مودم";

                        break;
                
                    default:
                        break;
                }

                if(!status){

                    message = "عدم اعتبار";

                    warrantyStatus.style.color = "red";
                }

                message = "معتبر";

                result = {

                    status: status,
        
                    devName: devName,
        
                    devSerialNumber: devSerialNumber,
        
                    devDeviceType: devDeviceType,
        
                    validUntil: validUntil
        
                }

                warrantyStatus.innerHTML = message;

                warrantyDevName.innerHTML = result.devName;

                warrantyDevSerialNumber.innerHTML = result.devSerialNumber;

                warrantyDeviceType.innerHTML = result.devDeviceType;

                warrantyValidUntil.innerHTML = result.validUntil;

            }
        });

    })


}

inquiryButton.addEventListener("click",(e)=>{

    e.preventDefault();

    submitText.style.display = "none";

    loading.style.display = "inline-block";

    inquryWarranty(serialNumber.value);

});